#include <algorithm>
#include <array>
#include <bitset>
#include <cassert>
#include <chrono>
#include <cmath>
#include <cstring>
#include <functional>
#include <iomanip>
#include <iostream>
#include <map>
#include <numeric>
#include <queue>
#include <random>
#include <set>
#include <vector>
using namespace std;

#define int long long
#define all(a) (a).begin(), (a).end()
#define rall(a) (a).rbegin(), (a).rend()

bool is_pal(int x) {
    string s = to_string(x);
    string t = s;
    reverse(all(t));
    return s == t;
}

const int INF = 1e18;
vector<int> dp;

void init() {
    dp.assign(1000, INF);
    dp[0] = 0;
    for (int x = 1; x < 1000; x++) {
        for (int y = 1; y <= x; y++) {
            if (is_pal(y)) {
                dp[x] = min(dp[x], dp[x - y] + 1);
            }
        }
    }
}

void solve() {
    int x;
    cin >> x;
    cout << dp[x] << '\n';
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    init();
    int tt;
    cin >> tt;
    while (tt--) {
        solve();
    }
}
